<Query Kind="Program">
  <Namespace>System.Net</Namespace>
  <Namespace>System.Net.Mail</Namespace>
  <Namespace>System.Net.Sockets</Namespace>
</Query>

class TcpDemo
{
	static void Main()
	{
		new Thread (Server).Start();       // współbieżne uruchomienie metody serwera
		Thread.Sleep (500);                // czas na uruchomienie serwera
		Client();
	}

	static void Client()
	{
		using (TcpClient client = new TcpClient ("localhost", 51111))
		using (NetworkStream n = client.GetStream())
		{
			BinaryWriter w = new BinaryWriter (n);
			w.Write ("Witaj");
			w.Flush();
			Console.WriteLine (new BinaryReader (n).ReadString());
		}
	}

	static void Server()     // obsługuje jedno żądanie klienta i kończy działanie
	{
		TcpListener listener = new TcpListener (IPAddress.Any, 51111);
		listener.Start();
		using (TcpClient c = listener.AcceptTcpClient())
		using (NetworkStream n = c.GetStream())
		{
			string msg = new BinaryReader (n).ReadString();
			BinaryWriter w = new BinaryWriter (n);
			w.Write (msg + " right back!");
			w.Flush();                      // wywołanie Flush jest konieczne, ponieważ
		}                                 // nie usuwamy writera
		listener.Stop();
	}
}